﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Zestawienie VAT zakupu wg typu dokumentu</title>

    <script runat="server">
		    
        public enum WgOkresu {
            Wpływu = 0,
            Wystawienia = 1,
            [Caption("Zakupu/Operacji")]
            Operacji = 2
        }

        public class ParametryBase : SerializableContextBase {
            public ParametryBase(Context cx)
                : base(cx) {
                int y = Date.Today.Year;
                int m = Date.Today.Month;
                Date from = m == 1 ? new Date(y-1,12,1) : new Date(y,m-1,1);
                Date to = from.LastDayMonth();
                okres = new FromTo(from, to);
            }

            WgOkresu wgOkresu = WgOkresu.Wpływu;

            DefinicjaStawkiVat[] definicjeStawekVAT = null;
			[Caption("Kolumny(stawki VAT)")]
			[Soneta.Tools.Priority(1)]
			[Required]
			public DefinicjaStawkiVat[] DefinicjeStawekVAT {
				get { return definicjeStawekVAT; }
				set { definicjeStawekVAT = value; }
			}

            [Priority(10)]
            [Caption("Wg daty")]
            public WgOkresu WgOkresu {
                get { return wgOkresu; }
                set {
                    wgOkresu = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            FromTo okres = FromTo.All;

            [Priority(20)]
            [Caption("Okres")]
            public FromTo Okres {
                get { return okres; }
                set {
                    if (value == FromTo.Empty)
                        value = FromTo.All;
                    okres = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        static ParametryBase parametry;

        [Context]
        public static ParametryBase Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total {
            readonly DokumentHandlowy dokument;
            
            public Total(DokumentHandlowy dokument) {
                this.dokument = dokument;
            }
            
            public DokumentHandlowy Dokument {
                get { return dokument; }
            }

            public enum ZwracanaSuma {
                Netto = 0,
                Vat = 1,
                Brutto = 2,
            }

            decimal ZwróćWartość(ZwracanaSuma zwracanaSuma, Percent procentStawki) {
                decimal suma = 0m;
                foreach (SumaVAT sv in dokument.SumyVAT) {
                    if (sv.Stawka.Procent != procentStawki) continue;
                    switch(zwracanaSuma) {
                        case ZwracanaSuma.Netto:
                            suma += sv.Suma.Netto;
                            break;
                        case ZwracanaSuma.Vat:
                            suma += sv.Suma.VAT;
                            break;
                        case ZwracanaSuma.Brutto:
                            suma += sv.Suma.Brutto;
                            break;
                    }
                }
                return suma;
            }

            decimal ZwróćWartość0(ZwracanaSuma zwracanaSuma) {
                decimal suma = 0m;                
                HandelModule hm = HandelModule.GetInstance(dokument.Session);
                DefinicjaStawkiVat definicja = hm.Core.DefStawekVat.Zero;
                foreach (SumaVAT sv in dokument.SumyVAT) {                    
                    if (sv.DefinicjaStawki != definicja) continue;
                    switch (zwracanaSuma) {
                        case ZwracanaSuma.Netto:
                            suma += sv.Suma.Netto;
                            break;
                        case ZwracanaSuma.Vat:
                            suma += sv.Suma.VAT;
                            break;
                        case ZwracanaSuma.Brutto:
                            suma += sv.Suma.Brutto;
                            break;
                    }
                }
                return suma;
            }

            decimal ZwróćWartośćNP(ZwracanaSuma zwracanaSuma) {
                decimal suma = 0m;
                HandelModule hm = HandelModule.GetInstance(dokument.Session);
                DefinicjaStawkiVat definicja = hm.Core.DefStawekVat.NiePodlega;
                foreach (SumaVAT sv in dokument.SumyVAT) {
                    if (sv.DefinicjaStawki != definicja) continue;
                    switch (zwracanaSuma) {
                        case ZwracanaSuma.Netto:
                            suma += sv.Suma.Netto;
                            break;
                        case ZwracanaSuma.Vat:
                            suma += sv.Suma.VAT;
                            break;
                        case ZwracanaSuma.Brutto:
                            suma += sv.Suma.Brutto;
                            break;
                    }
                }
                return suma;
            }

            decimal ZwróćWartośćZW(ZwracanaSuma zwracanaSuma) {
                decimal suma = 0m;
                HandelModule hm = HandelModule.GetInstance(dokument.Session);
                DefinicjaStawkiVat definicja = hm.Core.DefStawekVat.WgKodu["ZW"];
                foreach (SumaVAT sv in dokument.SumyVAT) {
                    if (sv.DefinicjaStawki != definicja) continue;
                    switch (zwracanaSuma) {
                        case ZwracanaSuma.Netto:
                            suma += sv.Suma.Netto;
                            break;
                        case ZwracanaSuma.Vat:
                            suma += sv.Suma.VAT;
                            break;
                        case ZwracanaSuma.Brutto:
                            suma += sv.Suma.Brutto;
                            break;
                    }
                }
                return suma;
            }

            public decimal Netto3 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.03m)); }
            }

            public decimal Vat3 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.03m)); }
            }

            public decimal Brutto3 {
                get { return ZwróćWartość(ZwracanaSuma.Brutto, new Percent(0.03m)); }
            }

            public decimal Netto5 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.05m)); }
            }

            public decimal Vat5 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.05m)); }
            }

            public decimal Brutto5 {
                get { return ZwróćWartość(ZwracanaSuma.Brutto, new Percent(0.05m)); }
            }

            public decimal Netto6 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.06m)); }
            }

            public decimal Vat6 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.06m)); }
            }

            public decimal Brutto6 {
                get { return ZwróćWartość(ZwracanaSuma.Brutto, new Percent(0.06m)); }
            }

            public decimal Netto7 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.07m)); }
            }

            public decimal Vat7 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.07m)); }
            }

            public decimal Brutto7 {
                get { return ZwróćWartość(ZwracanaSuma.Brutto, new Percent(0.07m)); }
            }

            public decimal Netto12 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.12m)); }
            }

            public decimal Vat12 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.12m)); }
            }

            public decimal Brutto12 {
                get { return ZwróćWartość(ZwracanaSuma.Brutto, new Percent(0.12m)); }
            }

            public decimal Netto22 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.22m)); }
            }
            
            public decimal Vat22 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.22m)); }
            }

            public decimal Brutto22 {
                get { return ZwróćWartość(ZwracanaSuma.Brutto, new Percent(0.22m)); }
            }
            
            public decimal NettoZW {
                get { return ZwróćWartośćZW(ZwracanaSuma.Netto); }
            }

            public decimal VatZW {
                get { return ZwróćWartośćZW(ZwracanaSuma.Vat); }
            }

            public decimal BruttoZW {
                get { return ZwróćWartośćZW(ZwracanaSuma.Brutto); }
            }
            
            public decimal Netto0 {
                get { return ZwróćWartość0(ZwracanaSuma.Netto); }
            }

            public decimal Vat0 {
                get { return ZwróćWartość0(ZwracanaSuma.Vat); }
            }

            public decimal Brutto0 {
                get { return ZwróćWartość0(ZwracanaSuma.Brutto); }
            }

            public decimal NettoNP {
                get { return ZwróćWartośćNP(ZwracanaSuma.Netto); }
            }

            public decimal VatNP {
                get { return ZwróćWartośćNP(ZwracanaSuma.Vat); }
            }

            public decimal BruttoNP {
                get { return ZwróćWartośćNP(ZwracanaSuma.Brutto); }
            }

            // nowe stawki
            public decimal Netto8 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.08m)); }
            }
            
            public decimal Vat8 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.08m)); }
            }

            public decimal Brutto8 {
                get { return ZwróćWartość(ZwracanaSuma.Brutto, new Percent(0.08m)); }
            }

            public decimal Netto23 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.23m)); }
            }
            
            public decimal Vat23 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.23m)); }
            }

            public decimal Brutto23 {
                get { return ZwróćWartość(ZwracanaSuma.Brutto, new Percent(0.23m)); }
            }

            public decimal Netto4 {
                get { return ZwróćWartość(ZwracanaSuma.Netto, new Percent(0.04m)); }
            }

            public decimal Vat4 {
                get { return ZwróćWartość(ZwracanaSuma.Vat, new Percent(0.04m)); }
            }

            public decimal Brutto4 {
                get { return ZwróćWartość(ZwracanaSuma.Brutto, new Percent(0.04m)); }
            }
                        
        }

        // Mateusz - dodanie nowych stawek VAT - 
        public class TotalStawki : IComparable {
        
            decimal nettoNP = 0m, vatNP = 0m, bruttoNP = 0m;
            decimal nettoZW = 0m, vatZW = 0m, bruttoZW = 0m;            
            decimal netto3 = 0m, vat3 = 0m, brutto3 = 0m;
            decimal netto5 = 0m, vat5 = 0m, brutto5 = 0m;
            decimal netto6 = 0m, vat6 = 0m, brutto6 = 0m;
            decimal netto7 = 0m, vat7 = 0m, brutto7 = 0m;
            decimal netto12 = 0m, vat12 = 0m, brutto12 = 0m;
            decimal netto22 = 0m, vat22 = 0m, brutto22 = 0m;
            decimal netto = 0m, vat = 0m, brutto = 0m;
            // nowe stawki
            decimal netto8 = 0m, vat8 = 0m, brutto8 = 0m;
            decimal netto23 = 0m, vat23 = 0m, brutto23 = 0m;

            // zmiana z netto0P na netto0 itd i dodanie stawki 4
            decimal netto0 = 0m, vat0 = 0m, brutto0 = 0m;
            decimal netto4 = 0m, vat4 = 0m, brutto4 = 0m;            
            
            readonly string opis;
            DefDokHandlowego definicja;
            public TotalStawki(DefDokHandlowego definicja) {
                this.opis = definicja.Symbol;
                this.definicja = definicja;
            }
            
            public void Add(Total t) {
                nettoNP += t.NettoNP;
                vatNP += t.VatNP;
                bruttoNP += t.BruttoNP;
                nettoZW += t.NettoZW;
                vatZW += t.VatZW;
                bruttoZW += t.BruttoZW;
                netto0 += t.Netto0;
                vat0 += t.Vat0;                
                brutto0 += t.Brutto0;
                netto3 += t.Netto3;
                vat3 += t.Vat3;
                brutto3 += t.Brutto3;
                netto5 += t.Netto5;
                vat5 += t.Vat5;
                brutto5 += t.Brutto5;
                netto6 += t.Netto6;
                vat6 += t.Vat6;
                brutto6 += t.Brutto6;                
                netto7 += t.Netto7;
                vat7 += t.Vat7;
                brutto7 += t.Brutto7;
                netto12 += t.Netto12;
                vat12 += t.Vat12;
                brutto12 += t.Brutto12;
                netto22 += t.Netto22;
                vat22 += t.Vat22;
                brutto22 += t.Brutto22;
                netto += t.Dokument.Suma.Netto;
                vat += t.Dokument.Suma.VAT;
                brutto += t.Dokument.Suma.Brutto;
                // nowe stawki
                netto8 += t.Netto8;
                vat8 += t.Vat8;
                brutto8 += t.Brutto8;
                netto23 += t.Netto23;
                vat23 += t.Vat23;
                brutto23 += t.Brutto23;
                
                netto4 += t.Netto4;
                brutto4 += t.Brutto4;
                vat4 += t.Vat4;
            }
            
            public string Opis { get { return opis; } }
            public decimal NettoNP { get { return nettoNP; } }
            public decimal VatNP { get { return vatNP; } }
            public decimal BruttoNP { get { return bruttoNP; } }
            public decimal NettoZW { get { return nettoZW; } }
            public decimal VatZW { get { return vatZW; } }
            public decimal BruttoZW { get { return bruttoZW; } }
            public decimal Netto0 { get { return netto0; } }
            public decimal Vat0 { get { return vat0; } }
            public decimal Brutto0 { get { return brutto0; } }
            public decimal Netto3 { get { return netto3; } }
            public decimal Vat3 { get { return vat3; } }
            public decimal Brutto3 { get { return brutto3; } }
            public decimal Netto5 { get { return netto5; } }
            public decimal Vat5 { get { return vat5; } }
            public decimal Brutto5 { get { return brutto5; } }
            public decimal Netto6 { get { return netto6; } }
            public decimal Vat6 { get { return vat6; } }
            public decimal Brutto6 { get { return brutto6; } }            
            public decimal Netto7 { get { return netto7; } }
            public decimal Vat7 { get { return vat7; } }
            public decimal Brutto7 { get { return brutto7; } }
            public decimal Netto12 { get { return netto12; } }
            public decimal Vat12 { get { return vat12; } }
            public decimal Brutto12 { get { return brutto12; } }
            public decimal Netto22 { get { return netto22; } }
            public decimal Vat22 { get { return vat22; } }
            public decimal Brutto22 { get { return brutto22; } }
            public decimal Netto { get { return netto; } }
            public decimal Vat { get { return vat; } }
            public decimal Brutto { get { return brutto; } }
            // nowe stawki
            public decimal Netto8 { get { return netto8; } }
            public decimal Vat8 { get { return vat8; } }
            public decimal Brutto8 { get { return brutto8; } }
            public decimal Netto23 { get { return netto23; } }
            public decimal Vat23 { get { return vat23; } }
            public decimal Brutto23 { get { return brutto23; } }
            
            public decimal Netto4 { get { return netto4; } }
            public decimal Vat4 { get { return vat4; } }
            public decimal Brutto4 { get { return brutto4; } }
            
            public int CompareTo(object obj) {
                TotalStawki ts = (TotalStawki)obj;
                string s1 = Opis;
                string s2 = ts.Opis;
                return s1.CompareTo(s2);
            }
        }

        public RowCondition KategoriaCondition() {
            return new FieldCondition.GreaterEqual("Kategoria", KategoriaHandlowa.Zakup)
                    & new FieldCondition.LessEqual("Kategoria", KategoriaHandlowa.KorektaZakupu);
        }

        Soneta.Business.View PrzygotujView(Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars) {
            HandelModule handel = HandelModule.GetInstance(pars);

            Soneta.Business.View view;

            //////////////////////////////////////////////////////////////////////
            /// Dla podmiotu
            /// 
            if (pars.Kontrahent != null) {
                SubTable st;
                if (pars.Magazyn != null) {
                    st = handel.DokHandlowe.WgKontrahent[pars.Kontrahent, pars.Magazyn];
                    if (pars.JestOkres)
                        st = new SubTable(st, pars.Okres);
                }
                else
                    st = handel.DokHandlowe.WgKontrahent[pars.Kontrahent];
                view = st.CreateView();
                if (pars.JestOkres && pars.Magazyn == null)
                    view.Condition &= new FieldCondition.Contain("Data", pars.Okres);
                if (pars.Definicja != null)
                    view.Condition &= new FieldCondition.Equal("Definicja", pars.Definicja);
            }

            ///////////////////////////////////////////////////////////////////////
            /// Definicja
            /// 
            else if (pars.Definicja != null && pars.Magazyn != null) {
                SubTable st = handel.DokHandlowe.WgDefinicja[pars.Definicja, pars.Magazyn];
                if (pars.JestOkres)
                    st = new SubTable(st, pars.Okres);
                view = st.CreateView();
            }

            //////////////////////////////////////////////////////////////////////
            /// Magazyn
            /// 
            else if (pars.Magazyn != null) {
                SubTable st = handel.DokHandlowe.WgMagazyn[pars.Magazyn];
                if (pars.JestOkres)
                    st = new SubTable(st, pars.Okres);

                view = st.CreateView();
            }

            //////////////////////////////////////////////////////////////////////
            /// Tylko okres
            /// 
            else {
                SubTable st = handel.DokHandlowe.WgDaty;
                if (pars.JestOkres)
                    st = new SubTable(st, pars.Okres);
                view = st.CreateView();
                if (pars.Definicja != null)
                    view.Condition &= new FieldCondition.Equal("Definicja", pars.Definicja);
            }

            view.Condition &= KategoriaCondition();
            
            if (!string.IsNullOrEmpty(pars.Seria))
                view.Condition &= new FieldCondition.Like("Seria", pars.Seria);

            if (!pars.Duplikaty)
                view.Condition &= new FieldCondition.Equal("Definicja.DuplikatWartosci", false);

            view.Condition &= DokHandlowe.UtwórzCondition("", pars.Stan);

            if (pars.WedługDaty == WedługDatyDokumentu.Terminu || pars.WedługDaty == WedługDatyDokumentu.PoTerminie) {
                if (pars.Okres != FromTo.All)
                    view.Condition &= new FieldCondition.Contain("Dostawa.Termin", pars.Okres.ValidDates);
                if (pars.WedługDaty == WedługDatyDokumentu.PoTerminie)
                    view.Condition &= !new RowCondition.Exists("RelacjaHandlowa", "Nadrzedny",
                        new FieldCondition.Equal("Typ", TypRelacjiHandlowej.Kopiowania) &
                        new FieldCondition.GreaterEqual("Rozliczenie", RozliczenieRelacji.CałośćWCzęściach));
            }
            
            switch (pars.Pozycje) {
                case FiltrPozycji.TylkoUsługi:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.Equal("Towar.Typ", TypTowaru.Usługa));
                    view.Condition &= new RowCondition.Not(
                        new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                            new FieldCondition.NotEqual("Towar.Typ", TypTowaru.Usługa)));
                    break;

                case FiltrPozycji.TylkoTowary:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.NotEqual("Towar.Typ", TypTowaru.Usługa));
                    view.Condition &= new RowCondition.Not(
                        new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.Equal("Towar.Typ", TypTowaru.Usługa)));
                    break;

                case FiltrPozycji.ZUsługami:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.Equal("Towar.Typ", TypTowaru.Usługa));
                    break;

                case FiltrPozycji.ZTowarami:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.NotEqual("Towar.Typ", TypTowaru.Usługa));
                    break;
            }

            switch (pars.Potwierdzenie) {
                case FiltrPotwierdzenia.Niepotwierdzone:
                    view.Condition &= new FieldCondition.Equal("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Niepotwierdzony);
                    break;

                case FiltrPotwierdzenia.Potwierdzone:
                    view.Condition &= new FieldCondition.Equal("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Potwierdzony);
                    break;

                case FiltrPotwierdzenia.Zaakceptowane:
                    view.Condition &= new FieldCondition.Equal("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Zaakceptowany);
                    break;

                case FiltrPotwierdzenia.Niezaakceptowane:
                    view.Condition &= new FieldCondition.NotEqual("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Zaakceptowany);
                    break;
            }            
            RowCondition rodzajCond = null;
            switch (pars.RodzajVAT) {
                case FiltrRodzajuVAT.Krajowe:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Krajowy);
                    break;

                case FiltrRodzajuVAT.Unijne:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Unijny);
                    break;
                case FiltrRodzajuVAT.UnijneTrójstronne:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.UnijnyTrójstronny);
                    break;
                case FiltrRodzajuVAT.UnijneRazem:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Unijny)
                        | new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.UnijnyTrójstronny);
                    break;

                case FiltrRodzajuVAT.Eksportowe:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Eksportowy);
                    break;
                case FiltrRodzajuVAT.EksportowePodróżne:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.EksportowyPodróżny);
                    break;
                case FiltrRodzajuVAT.EksportoweRazem:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Eksportowy)
                        | new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.EksportowyPodróżny);
                    break;
            }
            if (rodzajCond != null)
                view.Condition &= new RowCondition.Exists("DaneKontrahenta", "Host", rodzajCond
                    & new FieldCondition.Equal("Typ", DokumentHandlowy.TypDanychKontrahent));

            
            view.Condition &= pars.FiltrRelacji.Condition;            
            
            if (pars.OkresWpływu != FromTo.All)
                view.Condition &= new FieldCondition.GreaterEqual("Obcy.DataOtrzymania", pars.OkresWpływu.From) &
                                  new FieldCondition.LessEqual("Obcy.DataOtrzymania", pars.OkresWpływu.To);

            // <-- TID: 13760;            
            if (pars.OkresOperacji != FromTo.All)
            {                
                view.Condition &= new FieldCondition.GreaterEqual("DataOperacji", pars.OkresOperacji.From) &
                                  new FieldCondition.LessEqual("DataOperacji", pars.OkresOperacji.To);

            }
            view.FilterCondition += new ConditionHandler(view_FilterCondition);            
            return view;
        }
        
        private void view_FilterCondition(object sender, ConditionEventArgs args) {
            DokumentHandlowy dok = (DokumentHandlowy)args.Row;
            if (dok.Definicja.GetObjectRight() == AccessRights.Denied)
                args.Accepted = false;
        }
        
        protected void dc_ContextLoad(object sender, EventArgs e) {
            ReportHeader.Title += string.Format("|Okres {0}: {1}", CaptionAttribute.EnumToString(Parametry.WgOkresu), Parametry.Okres.ToString());
            
            Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
            
            switch(Parametry.WgOkresu) {
                case WgOkresu.Wpływu:
                    pars.Okres = FromTo.All;
                    pars.OkresOperacji = FromTo.All;
                    pars.OkresWpływu = Parametry.Okres;
                    break;
                case WgOkresu.Wystawienia:
                    pars.OkresWpływu = FromTo.All;
                    pars.OkresOperacji = FromTo.All;
                    pars.Okres = Parametry.Okres;                    
                    break;
                case WgOkresu.Operacji: // <-- TID: 13760;
                    pars.OkresWpływu = FromTo.All;
                    pars.Okres = FromTo.All;
                    pars.OkresOperacji = Parametry.Okres;
                    break;                     
            }
            
            
            // Mateusz - wybranie odpowiednich kolumn
            PrzygotujGrid( Parametry );
            
           Soneta.Business.View vw = PrzygotujView(pars);
            // Wyeliminowanie FN.
            vw.Condition &= new FieldCondition.NotEqual("Definicja.Intrastat", RodzajIntrastat.Przywóz);
            
            Hashtable result = new Hashtable();
            
            foreach(DokumentHandlowy dokument in vw) {                
                if (dokument.Definicja.DuplikatWartosci || dokument.Anulowany) continue;
                
                TotalStawki ts = (TotalStawki)result[dokument.Definicja];
                
                if (ts == null) {
                    ts = new TotalStawki(dokument.Definicja);
                    result.Add(dokument.Definicja, ts);
                }
                ts.Add(new Total(dokument));
            }

            ArrayList lista = new ArrayList(result.Values);
            lista.Sort();
            Grid.DataSource = lista;
        }

        private void PrzygotujGrid( ParametryBase param ) {
            if (param.DefinicjeStawekVAT != null && param.DefinicjeStawekVAT.Length != 0) {
                int index = 1;
                foreach (DefinicjaStawkiVat defVAT in param.DefinicjeStawekVAT) {
                    string stawka = defVAT.Kod.TrimEnd( new char[] { '%' } );
                    
                    // sprawdzić czy total zawiera property
                    if( typeof( TotalStawki ).GetProperty( "Netto"+stawka ) == null )
                        continue;

                    GridColumn gcNetto = new GridColumn();
					gcNetto.Caption = string.Format("Netto {0}", defVAT.Kod);
					gcNetto.Format = "{0:n}";
					gcNetto.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					gcNetto.Total = Soneta.Web.Total.Sum;
                    gcNetto.DataMember = "Netto"+stawka;
					Grid.Columns.Insert(index++, gcNetto);

                    GridColumn gcVAT = new GridColumn();
					gcVAT.Caption = string.Format("VAT {0}", defVAT.Kod);
					gcVAT.Format = "{0:n}";
					gcVAT.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					gcVAT.Total = Soneta.Web.Total.Sum;
					gcVAT.DataMember = "Vat"+stawka;
                    Grid.Columns.Insert(index++, gcVAT);

					GridColumn gcBrutto = new GridColumn();
					gcBrutto.Caption = string.Format("Brutto {0}", defVAT.Kod);
					gcBrutto.Format = "{0:n}";
					gcBrutto.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					gcBrutto.Total = Soneta.Web.Total.Sum;
                    gcBrutto.DataMember = "Brutto"+stawka;
					Grid.Columns.Insert(index++, gcBrutto);						
                }
            }
        }

    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="Form1" method="post" runat="server">
    <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad" Landscape="true"></ea:DataContext>
    <eb:ReportHeader ID="ReportHeader" runat="server" Title="Zestawienie VAT zakupu wg typu dokumentu">
    </eb:ReportHeader>
    <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" RowsInRow="3">
        <Columns>
            <ea:GridColumn ID="GridColumn1" runat="server" Align="Center" DataMember="Opis" Caption="Typ dokumentu" Total="Info" RowSpan="3"></ea:GridColumn>            
            <ea:GridColumn ID="GridColumn2" runat="server" Align="Right" DataMember="Netto" Caption="Netto" Total="Sum" Format="{0:n}"></ea:GridColumn>
            <ea:GridColumn ID="GridColumn3" runat="server" Align="Right" DataMember="Vat" Caption="VAT" Total="Sum" Format="{0:n}"></ea:GridColumn>
            <ea:GridColumn ID="GridColumn4" runat="server" Align="Right" DataMember="Brutto" Caption="Brutto" Total="Sum" Format="{0:n}"></ea:GridColumn>            
        </Columns>
    </ea:Grid>
    <eb:ReportFooter ID="ReportFooter" runat="server">
    </eb:ReportFooter>
    </form>
</body>
</html>